/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.settings.user;

import com.ibm.hwmca.fw.msgpanel.CommonMsgApp;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.Capabilities;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.TaskActionEvent;
import com.ibm.ui.framework.UserTaskManager;
import java.util.Map;

public class ObjectLockingSettingsBean
extends PanelBean {
    private static final String TRACE_MASKT = "HUSTBL T";
    private static final String TRACE_MASKF = "HUSTBL F";
    private static final String TRACE_MASKD = "HUSTBL D";
    private static final String SETTINGS_ELEMENTS = "ObjectLockSingformationGB";
    private String DEFAULTS_BUTTON_NAME = "DefaultsButton";
    private String RESET_BUTTON_NAME = "ResetButton";
    private String APPLY_BUTTON_NAME = "ApplyButton";
    private String CANCEL_BUTTON_NAME = "CancelButton";
    private String OK_BUTTON_NAME = "OKButton";
    private String CANCEL_ACTION_NAME = "CANCEL";
    private boolean originalLock;
    private boolean originalRelock;
    private boolean m_bAutoLockManagedObjectsToggle;
    private boolean m_bRelockAfterTaskToggle;

    public ObjectLockingSettingsBean(boolean lock, boolean relock) {
        this.setBeanName("com.ibm.hwmca.base.settings.user.ObjectLockingSettingsBean");
        this.originalLock = lock;
        this.originalRelock = relock;
    }

    private boolean hasSettingsChanged() {
        Trace.trace(TRACE_MASKF, "-> ObjectLockingSettingBean.hasSettingsChanged()");
        boolean result = false;
        if (this.m_bAutoLockManagedObjectsToggle != this.originalLock || this.m_bRelockAfterTaskToggle != this.originalRelock) {
            result = true;
        }
        Trace.trace(TRACE_MASKF, "<- ObjectLockingSettingBean.hasSettingsChanged(), result is " + result);
        return result;
    }

    public void update(Object object) {
        Trace.trace(TRACE_MASKF, "-> ObjectLockingSettingBean.update()");
        Map map = (Map)object;
        this.m_bAutoLockManagedObjectsToggle = (Boolean)map.get("lock");
        this.m_bRelockAfterTaskToggle = (Boolean)map.get("relock");
        this.refreshSettings(this.getUserTaskManager());
        Trace.trace(TRACE_MASKF, "<- ObjectLockingSettingBean.update()");
    }

    private void resetSettings(UserTaskManager utm) {
        Trace.trace(TRACE_MASKF, "<> ObjectLockingSettingBean.resetSettings()()");
        this.init();
        this.refreshSettings(utm);
    }

    private void refreshSettings(UserTaskManager utm) {
        Trace.trace(TRACE_MASKF, "<> ObjectLockingSettingBean.refreshSettings()()");
        utm.refreshAllElements();
    }

    void init() {
        this.m_bAutoLockManagedObjectsToggle = this.originalLock;
        this.m_bRelockAfterTaskToggle = this.originalRelock;
    }

    public void panelAction(TaskActionEvent evt) {
        Trace.trace(TRACE_MASKT, "-> ObjectLockingSettingBean.panelAction()");
        String actionCommand = evt.getActionCommand();
        Trace.trace(TRACE_MASKF, "   action command is " + evt.getActionCommand());
        UserTaskManager utm = (UserTaskManager)evt.getSource();
        if (actionCommand.equals(this.CANCEL_BUTTON_NAME) || actionCommand.equals(this.CANCEL_ACTION_NAME)) {
            this.handleCancelButton(utm);
        } else if (actionCommand.endsWith(this.APPLY_BUTTON_NAME)) {
            this.handleApplyButton(utm);
        } else if (actionCommand.endsWith(this.OK_BUTTON_NAME)) {
            this.handleOkButton(utm);
        } else if (actionCommand.endsWith(this.RESET_BUTTON_NAME)) {
            this.resetSettings(utm);
        } else if (actionCommand.endsWith(this.DEFAULTS_BUTTON_NAME)) {
            this.handleDefaultsButton(utm);
        } else {
            Trace.trace(TRACE_MASKF, "   Error, unknown action command");
        }
        Trace.trace(TRACE_MASKT, "<- ObjectLockingSettingBean.panelAction()");
    }

    private void handleCancelButton(UserTaskManager utm) {
        Trace.trace(TRACE_MASKF, "-> ObjectLockingSettingBean.handleCancelButton()");
        utm.storeAllElements();
        if (this.hasSettingsChanged() && !CommonMsgApp.showDataChangedConfirmation(utm)) {
            Trace.trace(TRACE_MASKF, "   throw away user input and end");
            throw new IllegalUserDataException();
        }
        this.sendCancelRequest(utm);
        Trace.trace(TRACE_MASKF, "<- ObjectLockingSettingBean.handleCancelButton()");
    }

    private void handleApplyButton(UserTaskManager utm) {
        Trace.trace(TRACE_MASKF, "-> ObjectLockingSettingBean.handleApplyButton()");
        if (this.hasSettingsChanged()) {
            PanelTaskletRequest request = new PanelTaskletRequest();
            request.setData("request", "update");
            request.setData("lock", this.m_bAutoLockManagedObjectsToggle);
            request.setData("relock", this.m_bRelockAfterTaskToggle);
            this.postTaskletRequest(request);
            this.originalLock = this.m_bAutoLockManagedObjectsToggle;
            this.originalRelock = this.m_bRelockAfterTaskToggle;
        }
        Trace.trace(TRACE_MASKF, "<- ObjectLockingSettingBean.handleApplyButton()");
    }

    private void handleOkButton(UserTaskManager utm) {
        Trace.trace(TRACE_MASKF, "-> ObjectLockingSettingBean.handleOkButton()");
        this.handleApplyButton(utm);
        this.sendCancelRequest(utm);
        Trace.trace(TRACE_MASKF, "<- ObjectLockingSettingBean.handleOkButton()");
    }

    private void handleDefaultsButton(UserTaskManager utm) {
        Trace.trace(TRACE_MASKF, "-> ObjectLockingSettingBean.handleDefaultsButton()");
        PanelTaskletRequest request = new PanelTaskletRequest();
        request.setData("request", "defaults");
        this.postTaskletRequest(request);
        Trace.trace(TRACE_MASKF, "<- ObjectLockingSettingBean.handleDefaultsButton()");
    }

    private void sendCancelRequest(UserTaskManager utm) {
        PanelTaskletRequest request = new PanelTaskletRequest();
        request.setCanceled();
        this.postTaskletRequest(request);
    }

    public boolean isAutoLockManagedObjectsToggle() {
        Trace.trace(TRACE_MASKF, "<> ObjectLockingSettingBean.isAutoLockManagedObjectsToggle(), return " + this.m_bAutoLockManagedObjectsToggle);
        return this.m_bAutoLockManagedObjectsToggle;
    }

    public void setAutoLockManagedObjectsToggle(boolean b) throws IllegalUserDataException {
        Trace.trace(TRACE_MASKF, "<> ObjectLockingSettingBean.setAutoLockManagedObjectsToggle(), b=" + b);
        this.m_bAutoLockManagedObjectsToggle = b;
    }

    public boolean isRelockAfterTaskToggle() {
        Trace.trace(TRACE_MASKF, "<> ObjectLockingSettingBean.isRelockAfterTaskToggle(), return " + this.m_bRelockAfterTaskToggle);
        return this.m_bRelockAfterTaskToggle;
    }

    public void setRelockAfterTaskToggle(boolean b) throws IllegalUserDataException {
        Trace.trace(TRACE_MASKF, "<> ObjectLockingSettingBean.setRelockAfterTaskToggle(), b=" + b);
        this.m_bRelockAfterTaskToggle = b;
    }

    public void load() {
        this.init();
    }

    public Capabilities getCapabilities() {
        return null;
    }

    public void verifyChanges() throws IllegalUserDataException {
    }

    public void save() {
    }
}

